//
//  MCPGDatabase+BPConveniences.h
//  BPAdmin
//
//  Created by Michael Clark on 10-02-25.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import <MCPostgresPersistence/MCPGDatabase.h>
#import <MCClientServer/MCClientServerDefines.h>

// Implements a bunch of conveniences
//  Also implements methods defined in <MCPostgresPersistence/MCPGDatabase+PGServerConveniences.h>

@interface MCPGDatabase (BPConveniences)

- (NSDictionary*)databaseConfiguration;
- (NSArray*)offlineDatabaseReplicantRecords;

// These return NO if there is an error; the value you want is in the perm returned by reference
- (BOOL)userNamed:(NSString *)username canUseBillingsPro:(BOOL*)perm error:(NSError **)error;
- (BOOL)userNamed:(NSString *)username canUseBillingsProTouch:(BOOL*)perm error:(NSError **)error;
- (BOOL)userNamed:(NSString *)username canUsePunchcard:(BOOL*)perm error:(NSError **)error;

- (NSDictionary*)billingsUserRecordForUserID: (NSNumber*)userID;
@end
